#ifndef __CModulatedXYPad__
#define __CModulatedXYPad__

#include "CXYPad.hpp"
using Exponent::GUI::Controls::CXYPad;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CModulatedXYPad CModulatedXYPad.hpp
			 * @brief An xy controller that also display the modulation position
			 *
			 * @date 13/06/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CModulatedXYPad.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CModulatedXYPad : public CXYPad
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CModulatedXYPad(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CModulatedXYPad();

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

				/**
				 * Set the modulation position
				 * @param xValue The modulation x position (0-1 range)
				 * @param yValue The modulation y position (0-1 range)
				 */
				virtual void setModulationPosition(const double xValue, const double yValue);

				/**
				 * Set hte modulation handle
				 * @param theHandle The image to use for the modulation position
				 */
				virtual void setModulationHandle(IImage *theHandle) { EXCHANGE_COUNTED_OBJECTS(m_modulationHandle, theHandle); }

				/**
				 * Set the x value
				 * @param xValue The x position
				 */
				virtual void setXValue(const double xValue);

				/**
				 * Set the y value
				 * @param yValue The y position
				 */
				virtual void setYValue(const double yValue);

//	===========================================================================


			protected:

//	===========================================================================

				CRect m_modulationHandlePosition;				/**< Position of the handle */
				IImage *m_modulationHandle;						/**< THe modulation handle */
			};
		}
	}
}
#endif	// End of CModulatedXYPad.hpp